import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TransitionRightIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-transition-right",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 3a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 18v-12a3 3 0 1 1 6 0v12a3 3 0 0 1 -6 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 12h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 15l3 -3l-3 -3"
    }, null), _createTextVNode(" ")]);
  }
};