import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TransitionTopIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-transition-top",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 6a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 21h12a3 3 0 0 0 0 -6h-12a3 3 0 0 0 0 6z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 10l3 -3l3 3"
    }, null), _createTextVNode(" ")]);
  }
};