import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TrophyIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-trophy",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21l8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 17l0 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 4l10 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 4v8a5 5 0 0 1 -10 0v-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode(" ")]);
  }
};