import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TrophyOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-trophy-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 17v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 4h9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 4v8c0 .31 -.028 .612 -.082 .905m-1.384 2.632a5 5 0 0 1 -8.534 -3.537v-5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};