import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TwentyFourHoursIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-24-hours",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 13a8.094 8.094 0 0 0 3 5.24"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 15v2a1 1 0 0 0 1 1h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 15v6"
    }, null), _createTextVNode(" ")]);
  }
};