import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TwoFactorAuthIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-2fa",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 16v-8h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 12l3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 16v-6a2 2 0 0 1 4 0v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 13l4 0"
    }, null), _createTextVNode(" ")]);
  }
};