import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TypographyOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-typography-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 20h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 20h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.9 15h6.9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 13l3 7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 20l4.09 -10.906"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.181 6.183l.819 -2.183h2l3.904 8.924"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};