import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'UnlinkIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-unlink",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 22v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 15l6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 6l.463 -.536a5 5 0 0 1 7.071 7.072l-.534 .464"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 18l-.397 .534a5.068 5.068 0 0 1 -7.127 0a4.972 4.972 0 0 1 0 -7.071l.524 -.463"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 17h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 7h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 2v2"
    }, null), _createTextVNode(" ")]);
  }
};