import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'UsbIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-usb",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 17v-11.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 10v3l5 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 14.5l5 -2v-2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 10h2v-2h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5.5h4l-2 -2.5z"
    }, null), _createTextVNode(" ")]);
  }
};