import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WallOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-wall-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 4h10a2 2 0 0 1 2 2v10m-.589 3.417c-.361 .36 -.86 .583 -1.411 .583h-12a2 2 0 0 1 -2 -2v-12c0 -.55 .222 -1.047 .58 -1.409"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 8h4m4 0h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 12h-4m-4 0h-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 16h12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 8v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 12v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 16v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};