import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WheelchairOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-wheelchair-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.582 17.59a2 2 0 0 0 2.833 2.824"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 14h-1.4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 6v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8h2m4 0h5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 8v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};