import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WhirlIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-whirl",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21c-3.314 0 -6 -2.462 -6 -5.5s2.686 -5.5 6 -5.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12c0 3.314 -2.462 6 -5.5 6s-5.5 -2.686 -5.5 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 14c3.314 0 6 -2.462 6 -5.5s-2.686 -5.5 -6 -5.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 12c0 -3.314 -2.462 -6 -5.5 -6s-5.5 2.686 -5.5 6"
    }, null), _createTextVNode(" ")]);
  }
};