import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WiperWashIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-wiper-wash",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11l5.5 5.5a5 5 0 0 1 7 0l5.5 -5.5a12 12 0 0 0 -18 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20l0 -14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 6a4 4 0 0 1 .4 -1.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 2.1a4 4 0 0 1 2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6a4 4 0 0 0 -.4 -1.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6a4 4 0 0 1 .4 -1.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 2.1a4 4 0 0 1 2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 6a4 4 0 0 0 -.4 -1.8"
    }, null), _createTextVNode(" ")]);
  }
};