import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WorldCogIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-world-cog",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12a9 9 0 1 0 -8.979 9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 9h16.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 15h8.9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 3a17 17 0 0 0 0 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 3a16.992 16.992 0 0 1 2.522 10.376"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 15.5v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 21v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22.032 17.25l-1.299 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.27 20l-1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.97 17.25l1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.733 20l1.3 .75"
    }, null), _createTextVNode(" ")]);
  }
};