import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WorldExclamationIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-world-exclamation",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.986 12.51a9 9 0 1 0 -5.71 7.873"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 9h16.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 15h10.9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 3a17 17 0 0 0 0 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 3a17 17 0 0 1 0 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 16v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 22v.01"
    }, null), _createTextVNode(" ")]);
  }
};