import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WorldMinusIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-world-minus",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.483 15.006a9 9 0 1 0 -7.958 5.978"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 9h16.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 15h16.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 3a17 17 0 0 0 0 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 3a16.94 16.94 0 0 1 2.307 12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 19h6"
    }, null), _createTextVNode(" ")]);
  }
};