import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WorldStarIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-world-star",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12a9 9 0 1 0 -9.968 8.948"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 9h16.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 15h6.4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 3a17.001 17.001 0 0 0 -1.886 13.802"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 3a16.982 16.982 0 0 1 2.549 8.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z"
    }, null), _createTextVNode(" ")]);
  }
};