import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'WorldWwwIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-world-www",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.5 7a9 9 0 0 0 -7.5 -4a8.991 8.991 0 0 0 -7.484 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 3a16.989 16.989 0 0 0 -1.826 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 3a16.989 16.989 0 0 1 1.828 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.5 17a9 9 0 0 1 -7.5 4a8.991 8.991 0 0 1 -7.484 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 21a16.989 16.989 0 0 1 -1.826 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 21a16.989 16.989 0 0 0 1.828 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 10l1 4l1.5 -4l1.5 4l1 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 10l1 4l1.5 -4l1.5 4l1 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 10l1 4l1.5 -4l1.5 4l1 -4"
    }, null), _createTextVNode(" ")]);
  }
};