import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ZodiacLeoIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-zodiac-leo",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 17a4 4 0 1 0 8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 7c0 3 2 5 2 9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 7c0 4 -2 6 -2 10"
    }, null), _createTextVNode(" ")]);
  }
};