import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ZoomInAreaIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-zoom-in-area",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 13v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 15h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 15m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 22l-3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 18h-1a2 2 0 0 1 -2 -2v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 6v-1a2 2 0 0 1 2 -2h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 3h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 3h1a2 2 0 0 1 2 2v1"
    }, null), _createTextVNode(" ")]);
  }
};