import './bootstrap';

import { createApp } from 'vue';

import console from './components/admin/app.vue';
import console_login from './components/admin/login.vue';
import console_router  from './routes/console.js';

import branch from './components/branch/app.vue';
import branch_index from './components/branch/index.vue';
import branch_router from './routes/branch.js';


import hr from './components/hr/app.vue';
import hr_index from './components/hr/index.vue';
import hr_register from './components/hr/register.vue';
import hr_router from './routes/hr.js';

import member from './components/member/app.vue';
import member_index from './components/member/index.vue';
import member_register from './components/member/register.vue';
import member_router from './routes/member.js';


import page from './components/pages/app.vue'
import page_login from './components/pages/login.vue';
import page_signup from './components/pages/signup.vue';
import page_forgot_password from './components/pages/forgot_password.vue';

import not_found from './components/not_found.vue';

import booking_router from './routes/booking.js';

var pathdot = window.location.hostname.split('.');
var pathArray = window.location.pathname.split('/');

var app;
var router;

if(pathdot[0].includes('console')) {
    router = console_router
    if(localStorage.getItem('token') && localStorage.getItem('staff')) {
        app = console
    }
    if(!localStorage.getItem('token') || !localStorage.getItem('staff')) {
        app = console_login
    }
}


if(pathdot[0].includes('hr')) {
    router = hr_router
    app = hr_index
    if(localStorage.getItem('token') && (localStorage.getItem('login_type') == 'hr')) {
        app = hr
    }
    
    if(pathArray.includes('register')) {
        app = hr_register
    }
}

if(pathdot[0].includes('branch')) {
    router = branch_router
    app = branch_index
    if(localStorage.getItem('token') && (localStorage.getItem('login_type') == 'branch')) {
        app = branch
    }
}

if(pathdot[0].includes('member')) {
    router = member_router
    app = member_index
    if(localStorage.getItem('token') && (localStorage.getItem('login_type') == 'member')) {
        app = member
    }
    if(pathArray.includes('register')) {
        app = member_register
    }
}

if(pathdot[0].includes('booking')) {
    router = booking_router
    if(localStorage.getItem('token')) {
        app = page
    }
    else {
        if(pathArray.includes('login')) {
            app = page_login
        }
        else if (pathArray.includes('signup')) {
            app = page_signup
        }
        else if (pathArray.includes('forgot_password')) {
            app = page_forgot_password
        }
        else {
            app = page_login
        }
    }
} 


// Vuetify
import '@mdi/font/css/materialdesignicons.css'
import 'vuetify/styles'
import { createVuetify } from 'vuetify'
import * as components from 'vuetify/components'
import * as directives from 'vuetify/directives'
import { i18nVue } from 'laravel-vue-i18n'; 


const vuetify = createVuetify({
  components,
  directives,
})

createApp(app).use(router).use(vuetify).use(i18nVue, { 
    resolve: async lang => {
        const langs = import.meta.glob('../../lang/*.json');
        return await langs[`../../lang/${lang}.json`]();
    }
}).mount("#app");
