import { createRouter, createWebHistory } from 'vue-router';

import adminDashboard from '../components/admin/dashboard.vue';

import adminSettingLanguageIndex from '../components/admin/others/language/index.vue'
import adminSettingRoleIndex from '../components/admin/others/role/index.vue'
import adminSettingUserIndex from '../components/admin/others/user/index.vue'

import adminCustomers from '../components/admin/customers/index.vue'

import pageNotFound from '../components/not_found.vue';

const routes = [
    {
        path: '/admin/login',
        name: 'admin_login',
        component: () => import('../components/admin/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/admin',
        name: 'admin_dashboard',
        component: () => import('../components/admin/dashboard.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/system',
        component: () => import('../components/admin/others/setting/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/languages',
        component: () => import('../components/admin/others/language/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/language/create',
        component: () => import('../components/admin/others/language/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/language/show/:id',
        props: true,
        component: () => import('../components/admin/others/language/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/language/edit/:id',
        props: true,
        component: () => import('../components/admin/others/language/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/customers',
        component: () => import('../components/admin/customers/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/customers/create',
        component: () => import('../components/admin/customers/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/customers/edit/:id',
        props: true,
        component: () => import('../components/admin/customers/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/customers/show/:id',
        component: () => import('../components/admin/customers/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/customers/email/:id',
        component: () => import('../components/admin/customers/email.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/appointments',
        component: () => import('../components/admin/appointment/appointments/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/sections',
        component: () => import('../components/admin/appointment/sections/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/section/create',
        component: () => import('../components/admin/appointment/sections/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/section/edit/:id',
        props: true,
        component: () => import('../components/admin/appointment/sections/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/section/show/:id',
        component: () => import('../components/admin/appointment/sections/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/status',
        component: () => import('../components/admin/appointment/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/status/create',
        component: () => import('../components/admin/appointment/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/status/edit/:id',
        props: true,
        component: () => import('../components/admin/appointment/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/appointment/status/show/:id',
        component: () => import('../components/admin/appointment/status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/projects',
        component: () => import('../components/admin/project/projects/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/projects/create',
        component: () => import('../components/admin/project/projects/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/projects/edit/:id',
        props: true,
        component: () => import('../components/admin/project/projects/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/projects/show/:id',
        component: () => import('../components/admin/project/projects/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/status',
        component: () => import('../components/admin/project/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/status/create',
        component: () => import('../components/admin/project/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/status/edit/:id',
        props: true,
        component: () => import('../components/admin/project/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/project/status/show/:id',
        component: () => import('../components/admin/project/status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/tasks',
        component: () => import('../components/admin/task/tasks/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/tasks/create',
        component: () => import('../components/admin/task/tasks/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/tasks/edit/:id',
        component: () => import('../components/admin/task/tasks/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/tasks/show/:id',
        component: () => import('../components/admin/task/tasks/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/status',
        component: () => import('../components/admin/task/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/status/create',
        component: () => import('../components/admin/task/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/status/edit/:id',
        component: () => import('../components/admin/task/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/task/status/show/:id',
        component: () => import('../components/admin/task/status/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/file_manager/',
        component: () => import('../components/admin/file_manager/index.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/categories',
        component: () => import('../components/admin/catalog/categories/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/categories/create',
        component: () => import('../components/admin/catalog/categories/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/categories/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/categories/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/categories/show/:id',
        component: () => import('../components/admin/catalog/categories/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/items',
        component: () => import('../components/admin/catalog/items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/items/create',
        component: () => import('../components/admin/catalog/items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/items/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/items/show/:id',
        component: () => import('../components/admin/catalog/items/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/packages',
        component: () => import('../components/admin/catalog/packages/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/package/create',
        component: () => import('../components/admin/catalog/packages/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/package/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/packages/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/catalog/package/show/:id',
        component: () => import('../components/admin/catalog/packages/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/orders',
        component: () => import('../components/admin/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/orders/create_custom',
        component: () => import('../components/admin/sales/orders/create_custom.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/orders/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/orders/show/:id',
        component: () => import('../components/admin/sales/orders/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/payment_methods',
        component: () => import('../components/admin/sales/payment_methods/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/payment_methods/create',
        component: () => import('../components/admin/sales/payment_methods/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/payment_methods/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/payment_methods/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/payment_methods/show/:id',
        component: () => import('../components/admin/sales/payment_methods/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_transactions',
        component: () => import('../components/admin/sales/order_transactions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_transaction/create',
        component: () => import('../components/admin/sales/order_transactions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_transaction/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/order_transactions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_transaction/show/:id',
        component: () => import('../components/admin/sales/order_transactions/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_status',
        component: () => import('../components/admin/sales/order_status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_status/create',
        component: () => import('../components/admin/sales/order_status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_status/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/order_status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/order_status/show/:id',
        component: () => import('../components/admin/sales/order_status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/conditions',
        component: () => import('../components/admin/sales/conditions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/conditions/create',
        component: () => import('../components/admin/sales/conditions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/conditions/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/conditions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/sales/conditions/show/:id',
        component: () => import('../components/admin/sales/conditions/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/companies',
        component: () => import('../components/admin/cooperation/companies/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/company/create',
        component: () => import('../components/admin/cooperation/companies/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/company/edit/:id',
        props: true,
        component: () => import('../components/admin/cooperation/companies/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/company/show/:id',
        component: () => import('../components/admin/cooperation/companies/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/stores',
        component: () => import('../components/admin/cooperation/stores/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/store/create',
        component: () => import('../components/admin/cooperation/stores/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/store/edit/:id',
        props: true,
        component: () => import('../components/admin/cooperation/stores/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/cooperation/store/show/:id',
        component: () => import('../components/admin/cooperation/stores/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/roles',
        component: adminSettingRoleIndex,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/role/create',
        component: () => import('../components/admin/others/role/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/role/edit/:id',
        props: true,
        component: () => import('../components/admin/others/role/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/role/show/:id',
        component: () => import('../components/admin/others/role/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/users',
        component: adminSettingUserIndex,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/user/create',
        component: () => import('../components/admin/others/user/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/user/edit/:id',
        component: () => import('../components/admin/others/user/update.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/admin/others/user/show/:id',
        component: () => import('../components/admin/others/user/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/',
        component: () => import('../components/pages/home.vue'),
        name: 'customer',
        meta: {
            auth: true
        }
    },
    {
        path: '/home',
        name: 'customer_home',
        component: () => import('../components/pages/home.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/journeies',
        name: 'customer_journeies',
        component: () => import('../components/pages/journey/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments',
        name: 'customer_appointments',
        component: () => import('../components/pages/appointment/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/orders',
        name: 'customer_orders',
        component: () => import('../components/pages/order/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/order/show/:id',
        name: 'customer_order_id',
        props: true,
        component: () => import('../components/pages/order/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/settings',
        name: 'customer_settings',
        component: () => import('../components/pages/customer/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/login',
        name: 'customer_login',
        component: () => import('../components/pages/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/signup',
        name: 'customer_signup',
        component: () => import('../components/pages/signup.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/not_found',
        component: pageNotFound
    }
]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    var pathdot = window.location.hostname.split('.');
    
    console.log(pathdot[0])
    
    var pathArray = window.location.pathname.split('/');
    
    console.log(pathArray)
    
    if(pathdot[0] == "admin") {
        console.log('route admin')
        if (to.name !== 'admin_login' && !localStorage.getItem('token') && !localStorage.getItem('staff')){
            return { name: 'admin_login' }
        }
        if(to.name == 'admin_login' && localStorage.getItem('token') && localStorage.getItem('staff')) {
            return { name: 'admin_dashboard' }
        }
    }
    
    if(pathArray.includes('booking')) { 
        console.log('route booking')
        if (!localStorage.getItem('token') && to.meta.auth == true){
            return  { name: 'customer_login' };
        }

        if(localStorage.getItem('token') && to.meta.auth == false) {
            return  { name: 'customer_home' };
        }    
    }

    

})

export default router;
