import { createRouter, createWebHistory } from 'vue-router';

import pageNotFound from '../components/not_found.vue';

const routes = [
    
    {
        path: '/',
        component: () => import('../components/pages/home.vue'),
        name: 'customer',
        meta: {
            auth: true
        }
    },
    {
        path: '/home',
        name: 'customer_home',
        component: () => import('../components/pages/home.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/journeies',
        name: 'customer_journeies',
        component: () => import('../components/pages/journey/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments',
        name: 'customer_appointments',
        component: () => import('../components/pages/appointment/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/orders',
        name: 'customer_orders',
        component: () => import('../components/pages/order/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/order/show/:id',
        name: 'customer_order_id',
        props: true,
        component: () => import('../components/pages/order/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/settings',
        name: 'customer_settings',
        component: () => import('../components/pages/customer/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/login',
        name: 'customer_login',
        component: () => import('../components/pages/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/signup',
        name: 'customer_signup',
        component: () => import('../components/pages/signup.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/not_found',
        component: pageNotFound
    }
]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    if (!localStorage.getItem('token') && to.meta.auth == true){
        return  { name: 'customer_login' };
    }

    if(localStorage.getItem('token') && to.meta.auth == false) {
        return  { name: 'customer_home' };
    }    
})

export default router;
