import { createRouter, createWebHistory } from 'vue-router';

const routes = [
    {
        path: '/:pathMatch(.*)*',
        component: () => import('../components/not_found.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/login',
        name: 'branch_login',
        component: () => import('../components/branch/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/',
        name: 'branch_dashboard',
        component: () => import('../components/branch/dashboard.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments',
        component: () => import('../components/branch/appointment/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/orders',
        component: () => import('../components/branch/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/create',
        component: () => import('../components/branch/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/appointment_order_create/:uniqid',
        props: true,
        component: () => import('../components/branch/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/edit/:uniqid',
        props: true,
        component: () => import('../components/branch/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/categories',
        component: () => import('../components/branch/catalog/categories/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/category/create',
        component: () => import('../components/branch/catalog/categories/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/category/edit/:uniqid',
        props: true,
        component: () => import('../components/branch/catalog/categories/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/items',
        component: () => import('../components/branch/catalog/items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/item/create',
        component: () => import('../components/branch/catalog/items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catelog/item/edit/:id',
        props: true,
        component: () => import('../components/branch/catalog/items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_items',
        component: () => import('../components/branch/member/catalogues/redeem_items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_item/create',
        component: () => import('../components/branch/member/catalogues/redeem_items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_item/edit/:uniqid',
        props: true,
        component: () => import('../components/branch/member/catalogues/redeem_items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupons',
        component: () => import('../components/branch/member/marketings/coupons/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupon/create',
        component: () => import('../components/branch/member/marketings/coupons/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupon/edit/:uniqid',
        props: true,
        component: () => import('../components/branch/member/marketings/coupons/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotions',
        component: () => import('../components/branch/member/marketings/promotions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotion/create',
        component: () => import('../components/branch/member/marketings/promotions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotion/edit/:uniqid',
        props: true,
        component: () => import('../components/branch/member/marketings/promotions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/orders',
        component: () => import('../components/branch/member/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/order/create',
        component: () => import('../components/branch/member/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/settings/profile',
        component: () => import('../components/branch/settings/profile.vue'),
        meta: {
            auth: true
        }
    }

]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    if (to.name !== 'branch_login' && !localStorage.getItem('token') && to.meta.auth == true){
        return { name: 'branch_login' }
    }
    
    if(to.name == 'branch_login' && localStorage.getItem('token') && (localStorage.getItem('login_type') == 'branch')) {
        return { name: 'branch_dashboard' }
    }
    
    
})

export default router;
