import { createRouter, createWebHistory } from 'vue-router';

import adminDashboard from '../components/admin/dashboard.vue';

import adminSettingLanguageIndex from '../components/admin/others/language/index.vue'
import adminSettingRoleIndex from '../components/admin/others/role/index.vue'
import adminSettingUserIndex from '../components/admin/others/user/index.vue'

// import adminCustomers from '../components/admin/customers/index.vue'

import pageNotFound from '../components/not_found.vue';

const routes = [
    {
        path: '/login',
        name: 'admin_login',
        component: () => import('../components/admin/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/admin',
        name: 'admin_dashboard',
        component: () => import('../components/admin/dashboard.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/members',
        component: () => import('../components/admin/member/members/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/member/create',
        component: () => import('../components/admin/member/members/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/member/edit/:uniqid',
        component: () => import('../components/admin/member/members/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/member/show/:uniqid',
        component: () => import('../components/admin/member/members/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/levels',
        component: () => import('../components/admin/member/levels/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/level/create',
        component: () => import('../components/admin/member/levels/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/level/edit/:uniqid',
        component: () => import('../components/admin/member/levels/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/level/show/:uniqid',
        component: () => import('../components/admin/member/levels/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/mile_stones',
        component: () => import('../components/admin/member/mile_stones/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/mile_stone/create',
        component: () => import('../components/admin/member/mile_stones/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/mile_stone/edit/:uniqid',
        component: () => import('../components/admin/member/mile_stones/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/mile_stone/show/:uniqid',
        component: () => import('../components/admin/member/mile_stones/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/point_items',
        component: () => import('../components/admin/member/catalogues/point_items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/point_item/create',
        component: () => import('../components/admin/member/catalogues/point_items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/point_item/edit/:uniqid',
        component: () => import('../components/admin/member/catalogues/point_items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/point_item/show/:uniqid',
        component: () => import('../components/admin/member/catalogues/point_items/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_items',
        component: () => import('../components/admin/member/catalogues/redeem_items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_item/create',
        component: () => import('../components/admin/member/catalogues/redeem_items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_item/edit/:uniqid',
        component: () => import('../components/admin/member/catalogues/redeem_items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/catalogues/redeem_item/show/:uniqid',
        component: () => import('../components/admin/member/catalogues/redeem_items/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/orders',
        component: () => import('../components/admin/member/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/order/create',
        component: () => import('../components/admin/member/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/order/edit/:uniqid',
        component: () => import('../components/admin/member/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/order/show/:uniqid',
        component: () => import('../components/admin/member/sales/orders/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/transactions',
        component: () => import('../components/admin/member/sales/transactions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/transaction/create',
        component: () => import('../components/admin/member/sales/transactions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/transaction/edit/:uniqid',
        component: () => import('../components/admin/member/sales/transactions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/sales/transaction//:uniqid',
        component: () => import('../components/admin/member/sales/transactions/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupons',
        component: () => import('../components/admin/member/marketings/coupons/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupon/create',
        component: () => import('../components/admin/member/marketings/coupons/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupon/edit/:uniqid',
        component: () => import('../components/admin/member/marketings/coupons/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/coupon/show/:uniqid',
        component: () => import('../components/admin/member/marketings/coupons/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotions',
        component: () => import('../components/admin/member/marketings/promotions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotion/create',
        component: () => import('../components/admin/member/marketings/promotions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotion/edit/:uniqid',
        component: () => import('../components/admin/member/marketings/promotions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/member/marketings/promotion/show/:uniqid',
        component: () => import('../components/admin/member/marketings/promotions/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/system',
        component: () => import('../components/admin/others/setting/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/languages',
        component: () => import('../components/admin/others/language/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/language/create',
        component: () => import('../components/admin/others/language/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/language/show/:id',
        props: true,
        component: () => import('../components/admin/others/language/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/language/edit/:id',
        props: true,
        component: () => import('../components/admin/others/language/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/customer/customers',
        component: () => import('../components/admin/customer/customers/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/customers/create',
        component: () => import('../components/admin/customer/customers/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/customers/edit/:id',
        props: true,
        component: () => import('../components/admin/customer/customers/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/customers/show/:id',
        component: () => import('../components/admin/customer/customers/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/customers/email/:id',
        component: () => import('../components/admin/customer/customers/email.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/appointments',
        component: () => import('../components/admin/appointment/appointments/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/sections',
        component: () => import('../components/admin/appointment/sections/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/section/create',
        component: () => import('../components/admin/appointment/sections/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/section/edit/:id',
        props: true,
        component: () => import('../components/admin/appointment/sections/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/section/show/:id',
        component: () => import('../components/admin/appointment/sections/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/status',
        component: () => import('../components/admin/appointment/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/status/create',
        component: () => import('../components/admin/appointment/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/status/edit/:id',
        props: true,
        component: () => import('../components/admin/appointment/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointment/status/show/:id',
        component: () => import('../components/admin/appointment/status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/project/projects',
        component: () => import('../components/admin/project/projects/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/projects/create',
        component: () => import('../components/admin/project/projects/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/projects/edit/:id',
        props: true,
        component: () => import('../components/admin/project/projects/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/projects/show/:id',
        component: () => import('../components/admin/project/projects/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/project/status',
        component: () => import('../components/admin/project/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/status/create',
        component: () => import('../components/admin/project/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/status/edit/:id',
        props: true,
        component: () => import('../components/admin/project/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/project/status/show/:id',
        component: () => import('../components/admin/project/status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/task/tasks',
        component: () => import('../components/admin/task/tasks/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/tasks/create',
        component: () => import('../components/admin/task/tasks/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/tasks/edit/:id',
        component: () => import('../components/admin/task/tasks/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/tasks/show/:id',
        component: () => import('../components/admin/task/tasks/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/status',
        component: () => import('../components/admin/task/status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/status/create',
        component: () => import('../components/admin/task/status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/status/edit/:id',
        component: () => import('../components/admin/task/status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/task/status/show/:id',
        component: () => import('../components/admin/task/status/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/file_manager/',
        component: () => import('../components/admin/file_manager/index.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/categories',
        component: () => import('../components/admin/catalog/categories/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/categories/create',
        component: () => import('../components/admin/catalog/categories/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/categories/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/categories/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/categories/show/:id',
        component: () => import('../components/admin/catalog/categories/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/items',
        component: () => import('../components/admin/catalog/items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/items/create',
        component: () => import('../components/admin/catalog/items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/items/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/items/show/:id',
        component: () => import('../components/admin/catalog/items/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/packages',
        component: () => import('../components/admin/catalog/packages/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/package/create',
        component: () => import('../components/admin/catalog/packages/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/package/edit/:id',
        props: true,
        component: () => import('../components/admin/catalog/packages/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/catalog/package/show/:id',
        component: () => import('../components/admin/catalog/packages/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/orders',
        component: () => import('../components/admin/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/create',
        component: () => import('../components/admin/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/show/:id',
        component: () => import('../components/admin/sales/orders/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/payment_methods',
        component: () => import('../components/admin/sales/payment_methods/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/payment_methods/create',
        component: () => import('../components/admin/sales/payment_methods/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/payment_methods/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/payment_methods/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/payment_methods/show/:id',
        component: () => import('../components/admin/sales/payment_methods/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_transactions',
        component: () => import('../components/admin/sales/order_transactions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_transaction/create',
        component: () => import('../components/admin/sales/order_transactions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_transaction/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/order_transactions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_transaction/show/:id',
        component: () => import('../components/admin/sales/order_transactions/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_status',
        component: () => import('../components/admin/sales/order_status/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_status/create',
        component: () => import('../components/admin/sales/order_status/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_status/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/order_status/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order_status/show/:id',
        component: () => import('../components/admin/sales/order_status/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/conditions',
        component: () => import('../components/admin/sales/conditions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/conditions/create',
        component: () => import('../components/admin/sales/conditions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/conditions/edit/:id',
        props: true,
        component: () => import('../components/admin/sales/conditions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/conditions/show/:id',
        component: () => import('../components/admin/sales/conditions/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/companies',
        component: () => import('../components/admin/cooperation/companies/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/company/create',
        component: () => import('../components/admin/cooperation/companies/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/company/edit/:id',
        props: true,
        component: () => import('../components/admin/cooperation/companies/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/company/show/:id',
        component: () => import('../components/admin/cooperation/companies/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/stores',
        component: () => import('../components/admin/cooperation/stores/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/store/create',
        component: () => import('../components/admin/cooperation/stores/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/store/edit/:id',
        props: true,
        component: () => import('../components/admin/cooperation/stores/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/cooperation/store/show/:id',
        component: () => import('../components/admin/cooperation/stores/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/categories',
        component: () => import('../components/admin/branch/catalog/categories/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/category/create',
        component: () => import('../components/admin/branch/catalog/categories/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/category/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/catalog/categories/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/category/show/:id',
        component: () => import('../components/admin/branch/catalog/categories/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/items',
        component: () => import('../components/admin/branch/catalog/items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/item/create',
        component: () => import('../components/admin/branch/catalog/items/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/item/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/catalog/items/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/catalog/item/show/:id',
        component: () => import('../components/admin/branch/catalog/items/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/customers',
        component: () => import('../components/admin/branch/customer/customers/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/customer/create',
        component: () => import('../components/admin/branch/customer/customers/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/customer/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/customer/customers/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/customer/show/:id',
        component: () => import('../components/admin/branch/customer/customers/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/memberships',
        component: () => import('../components/admin/branch/customer/memberships/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/membership/create',
        component: () => import('../components/admin/branch/customer/memberships/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/membership/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/customer/memberships/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/customer/membership/show/:id',
        component: () => import('../components/admin/branch/customer/memberships/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/orders',
        component: () => import('../components/admin/branch/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/order/create',
        component: () => import('../components/admin/branch/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/order/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/order/show/:id',
        component: () => import('../components/admin/branch/sales/orders/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/transactions',
        component: () => import('../components/admin/branch/sales/transactions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/transaction/create',
        component: () => import('../components/admin/branch/sales/transactions/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/transaction/edit/:id',
        props: true,
        component: () => import('../components/admin/branch/sales/transactions/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/sales/transaction/show/:id',
        component: () => import('../components/admin/branch/sales/transactions/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/roles',
        component: () => import('../components/admin/hr/roles/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/role/create',
        component: () => import('../components/admin/hr/roles/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/role/edit/:id',
        props: true,
        component: () => import('../components/admin/hr/roles/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/role/show/:id',
        component: () => import('../components/admin/hr/roles/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/users',
        component: () => import('../components/admin/hr/users/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/user/create',
        component: () => import('../components/admin/hr/users/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/user/edit/:id',
        component: () => import('../components/admin/hr/users/update.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/user/show/:id',
        component: () => import('../components/admin/hr/users/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/sales/orders',
        component: () => import('../components/admin/hr/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/sales/branch_orders',
        component: () => import('../components/admin/hr/sales/branch_orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/referals',
        component: () => import('../components/admin/hr/commissions/referal/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/users',
        component: () => import('../components/admin/hr/commissions/user/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/user/create',
        component: () => import('../components/admin/hr/commissions/user/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/user/edit/:id',
        component: () => import('../components/admin/hr/commissions/user/update.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/user/show/:id',
        component: () => import('../components/admin/hr/commissions/user/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/superiors',
        component: () => import('../components/admin/hr/commissions/superior/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/superior/create',
        component: () => import('../components/admin/hr/commissions/superior/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/superior/edit/:id',
        component: () => import('../components/admin/hr/commissions/superior/update.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/commissions/superior/show/:id',
        component: () => import('../components/admin/hr/commissions/superior/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/reports/users',
        component: () => import('../components/admin/hr/reports/user/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/reports/teams',
        component: () => import('../components/admin/hr/reports/team/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/reports/superiors',
        component: () => import('../components/admin/hr/reports/superior/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/reports/rewards',
        component: () => import('../components/admin/hr/reports/reward/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/hr/others',
        component: () => import('../components/admin/hr/others/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/roles',
        component: adminSettingRoleIndex,
        meta: {
            auth: true
        }
    },
    {
        path: '/others/role/create',
        component: () => import('../components/admin/others/role/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/role/edit/:id',
        props: true,
        component: () => import('../components/admin/others/role/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/role/show/:id',
        component: () => import('../components/admin/others/role/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/others/users',
        component: adminSettingUserIndex,
        meta: {
            auth: true
        }
    },
    {
        path: '/others/user/create',
        component: () => import('../components/admin/others/user/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/others/user/edit/:id',
        component: () => import('../components/admin/others/user/update.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/others/user/show/:id',
        component: () => import('../components/admin/others/user/show.vue'),
        props: true,
        meta: {
            auth: true
        }
    },
    {
        path: '/',
        component: () => import('../components/pages/home.vue'),
        name: 'customer',
        meta: {
            auth: true
        }
    },
    {
        path: '/home',
        name: 'customer_home',
        component: () => import('../components/pages/home.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/journeies',
        name: 'customer_journeies',
        component: () => import('../components/pages/journey/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments',
        name: 'customer_appointments',
        component: () => import('../components/pages/appointment/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/orders',
        name: 'customer_orders',
        component: () => import('../components/pages/order/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/order/show/:id',
        name: 'customer_order_id',
        props: true,
        component: () => import('../components/pages/order/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/settings',
        name: 'customer_settings',
        component: () => import('../components/pages/customer/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/login',
        name: 'customer_login',
        component: () => import('../components/pages/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/signup',
        name: 'customer_signup',
        component: () => import('../components/pages/signup.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/not_found',
        component: pageNotFound
    }
]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    var pathdot = window.location.hostname.split('.');
    
    // console.log(pathdot[0])
    
    var pathArray = window.location.pathname.split('/');
    
    // console.log(pathArray)
    
    if(pathdot[0] == "admin") {
        // console.log('route admin')
        if (to.name !== 'admin_login' && !localStorage.getItem('token') && !localStorage.getItem('staff')){
            return { name: 'admin_login' }
        }
        if(to.name == 'admin_login' && localStorage.getItem('token') && localStorage.getItem('staff')) {
            return { name: 'admin_dashboard' }
        }
    }
    
    // if(pathArray.includes('booking')) { 
    //     // console.log('route booking')
    //     if (!localStorage.getItem('token') && to.meta.auth == true){
    //         return  { name: 'customer_login' };
    //     }

    //     if(localStorage.getItem('token') && to.meta.auth == false) {
    //         return  { name: 'customer_home' };
    //     }    
    // }

    

})

export default router;
