import { createRouter, createWebHistory } from 'vue-router';

const routes = [
    {
        path: '/:pathMatch(.*)*',
        component: () => import('../components/not_found.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/register',
        component: () => import('../components/hr/register.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/login',
        name: 'login',
        component: () => import('../components/hr/login.vue'),
        meta: {
            auth: false
        }
    },
    {
        path: '/',
        name: 'dashboard',
        component: () => import('../components/hr/dashboard.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/customers',
        component: () => import('../components/hr/appointments/customers/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/customer/create',
        component: () => import('../components/hr/appointments/customers/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/customer/edit/:uniqid',
        props: true,
        component: () => import('../components/hr/appointments/customers/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/appointments',
        component: () => import('../components/hr/appointments/appointments/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/appointment/create',
        component: () => import('../components/hr/appointments/appointments/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/appointments/appointment/edit/:uniqid',
        props: true,
        component: () => import('../components/hr/appointments/appointments/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branches/orders',
        component: () => import('../components/hr/branches/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branches/commissions',
        component: () => import('../components/hr/branches/commissions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/orders',
        component: () => import('../components/hr/sales/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/create',
        component: () => import('../components/hr/sales/orders/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/order/edit/:uniqid',
        props: true,
        component: () => import('../components/hr/sales/orders/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/transactions',
        component: () => import('../components/hr/sales/transactions/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/sales/referals',
        component: () => import('../components/hr/sales/referals/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/users',
        component: () => import('../components/hr/users/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/user/create',
        component: () => import('../components/hr/users/create.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/user/edit/:uniqid',
        props: true,
        component: () => import('../components/hr/users/update.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/settings/profile',
        component: () => import('../components/hr/settings/profile.vue'),
        meta: {
            auth: true
        }
    },

]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    if (to.name !== 'hr_login' && !localStorage.getItem('token') && to.meta.auth == true){
        return { name: 'login' }
    }
    
    if(to.name == 'hr_login' && localStorage.getItem('token') && (localStorage.getItem('login_type') == 'hr')) {
        return { name: 'dashboard' }
    }
    
    
})

export default router;
