import { createRouter, createWebHistory } from 'vue-router';

const routes = [
    {
        path: '/:pathMatch(.*)*',
        component: () => import('../components/not_found.vue'),
        meta: {
            auth: false
        }
    }, // Not Found
    {
        path: '/login',
        name: 'member_login',
        component: () => import('../components/member/login.vue'),
        meta: {
            auth: false
        }
    }, // Login
    {
        path: '/register',
        component: () => import('../components/member/register.vue'),
        meta: {
            auth: false
        }
    }, // Register
    {
        path: '/',
        name: 'member_dashboard',
        component: () => import('../components/member/dashboard.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/point_items',
        component: () => import('../components/member/point_items/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/point_item/show/:uniqid',
        props: true,
        component: () => import('../components/member/point_items/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branches',
        component: () => import('../components/member/branches/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/branch/store/:uniqid',
        component: () => import('../components/member/branches/store.vue'),
        meta: {
            auth: true
        }
    },
    // {
    //     path: '/redeem_item/cart',
    //     component: () => import('../components/member/redeem_items/cart.vue'),
    //     meta: {
    //         auth: true
    //     }
    // },
    {
        path: '/point_activity',
        component: () => import('../components/member/point_activity/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/orders',
        component: () => import('../components/member/orders/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/order/show/:uniqid',
        props: true,
        component: () => import('../components/member/orders/show.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/order/success',
        props: true,
        component: () => import('../components/member/orders/success.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/membership',
        component: () => import('../components/member/membership/index.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/name',
        component: () => import('../components/member/personal_information/name.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/email',
        component: () => import('../components/member/personal_information/email.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/telephone',
        component: () => import('../components/member/personal_information/telephone.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/birthday',
        component: () => import('../components/member/personal_information/birthday.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/password',
        component: () => import('../components/member/personal_information/password.vue'),
        meta: {
            auth: true
        }
    },
    {
        path: '/personal_information/language',
        component: () => import('../components/member/personal_information/language.vue'),
        meta: {
            auth: true
        }
    }

]

const router = createRouter({
    history: createWebHistory(),
    routes
});

router.beforeEach((to, from) => {
    
    if (to.name !== 'member_login' && !localStorage.getItem('token') && to.meta.auth == true){
        return { name: 'member_login' }
    }
    
    if(to.name == 'member_login' && localStorage.getItem('token') && (localStorage.getItem('login_type') == 'member')) {
        return { name: 'member_dashboard' }
    }
    
    
})

export default router;
