<!doctype html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

        <title>帳單 {{ $order_id }}</title>

        <style >
            
            body {
                font-family: simhei;
            }
            
            h3 {
                font-family: simhei;
            }

        h4 { margin: 0;}
        .w-full { width: 100%; }
        .w-half { width: 50%; vertical-align: top; }
        .margin-top { margin-top: 1.25rem; }
        .footer { font-size: 0.875rem; padding: 1rem; background-color: #f2f2f2; }
        table { width: 100%; border-spacing: 0; }
        table.products, table.transactions { font-size: 0.875rem; }
        table.products tr, table.transactions tr { background-color: #ddd; }
        table.products th, table.transactions th { padding: 0.5rem; }
        table.products tr:nth-child(even), table.transactions tr:nth-child(even){background-color: #fff;}
        table tr.items { background-color: #f2f2f2 }
        table tr.items td { padding: 0.5rem; }
        .total { text-align: right; margin-top: 1rem; font-size: 0.875rem; background-color: #f2f2f2}
        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; } 
        
    </style>
</head>
<body>

    <table class="w-full">
        <tr>
            <td class="w-half">
                <!-- <img src="1707759457_joseph-photo-logo.png" width="200" height="100" /> -->
                <img src="{{ substr(config('invoice_logo'), 1) }}" width="200">
                
                <!-- <img src="/{{ asset('storage/setting/system/' . config('faviconImgPreview')) }}" width="200"> -->
            </td>
            <td class="w-half text-right">
                <div>發票編號: {{ $order_id }}</div>
            </td>
        </tr>
    </table>

    <div class="margin-top">
        <table class="w-full">
            <tr>
                <td class="w-half">
                    <div>客戶信息: </div>
                    @if($order->order_customers[0]->company != "")
                    <div>{{ $order->order_customers[0]->company}}</div>
                    @endif
                    <div>{{ $order->order_customers[0]->name}}</div>
                    <div>{{ $order->order_customers[0]->email}}</div>
                    <div>{{ $order->order_customers[0]->telephone}}</div>
                </td>
                <td class="w-half">
                    <div>公司地址：</div>
                    <div>{{ config('address') }}</div>
                    
                </td>
            </tr>
        </table>
    </div>

    <div class="margin-top">
        <table class="products">
            <tr>
                <td class="text-center">#</td>
                <td class="text-center">描述</td>
                <td class="text-center"><div>售價</div></td>
                <td class="text-center"><div>數量</div></td>
                <td class="text-center"><div>總計</div></td>
            </tr>
            @foreach($order->items as $index => $item)
                <tr class="items">
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td class="text-left">{{ $item['detail'] }}</td>
                    <td class="text-center">{{ config('currency_symbol') }}{{ number_format($item['unit_price'], 2, '.', ',') }}</td>

                    <td  class="text-center">{{ $item['quantity'] }}</td>
                    <td class="text-right">{{ config('currency_symbol') }}{{ number_format($item['total'], 2, '.', ',') }}</td>
                </tr>
            @endforeach
            
            <tr class="total">
                <td class="text-center"></td>
                <td class="text-left"></td>
                <td class="text-center"></td>
                <td  class="text-center">小計：</td>
                <td class="text-right">{{ config('currency_symbol') }}{{ number_format($order->total, 2, '.', ',') }}</td>
            </tr>
            <tr class="total">
                <td class="text-center"></td>
                <td class="text-left"></td>
                <td class="text-center"></td>
                <td  class="text-center">支付：</td>
                <td class="text-right">{{ config('currency_symbol') }}{{ number_format($total_payment, 2, '.', ',') }}</td>
            </tr>
            <tr class="total">
                <td class="text-center"></td>
                <td class="text-left"></td>
                <td class="text-center"></td>
                <td  class="text-center">結餘：</td>
                <td class="text-right">{{ config('currency_symbol') }}{{ number_format($order->total - $total_payment, 2, '.', ',') }}</td>
            </tr>
        </table>
    </div>

    <div class="margin-top">
        <table class="transactions">
            <tr>
                <td class="text-center">#</td>
                <td class="text-center">付款日期</td>
                <td class="text-center">付款方法</td>
                <td class="text-center">總計</td>
            </tr>
            @foreach($order->transactions as $index => $transaction)
                <tr class="items">
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td class="text-center">{{ $transaction['created_at'] }}</td>
                    <td class="text-center">{{ $transaction['payment_method'] }}</td>
                    <td class="text-right">{{ config('currency_symbol') }}{{ number_format($transaction['payment_amount'], 2, '.', ',') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    @if($order->comment != "")
    <div class="footer margin-top">
        <div>備註:</div>
        <div>{!! $order->comment !!}</div>
    </div>
    @endif

    <div class="footer margin-top">
        @if(config('invoice_conditions') != "")
            <div>{!! config('invoice_conditions') !!}</div>
        @endif
        <div>Thank you</div>
        <div>{{ config('invoice_footer') }}</div>
    </div>
</body>
</html>
