<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('global_index', [App\Http\Controllers\SettingController::class, 'index']);
Route::get('change_language', [App\Http\Controllers\LanguageController::class, 'change_language']);

// Console Member Marketing Promotions
Route::get('console/member/marketings/promotions', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'index']);
Route::get('console/member/marketings/promotion/create', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'create']);
Route::post('console/member/marketings/promotion/store', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'store']);
Route::get('console/member/marketings/promotion/show/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'show']);
Route::get('console/member/marketings/promotion/edit/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'edit']);
Route::post('console/member/marketings/promotion/update/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'update']);
Route::get('console/member/marketings/promotion/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\PromotionController::class, 'destroy']);

// Console Member Marketing Coupon
Route::get('console/member/marketings/coupons', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'index']);
Route::get('console/member/marketings/coupon/create', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'create']);
Route::post('console/member/marketings/coupon/store', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'store']);
Route::get('console/member/marketings/coupon/show/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'show']);
Route::get('console/member/marketings/coupon/edit/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'edit']);
Route::post('console/member/marketings/coupon/update/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'update']);
Route::get('console/member/marketings/coupon/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\Marketings\CouponController::class, 'destroy']);

// Console Catalogue Redeem Item
Route::get('console/member/catalogues/redeem_items', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'index']);
Route::get('console/member/catalogues/redeem_item/create', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'create']);
Route::post('console/member/catalogues/redeem_item/store', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'store']);
Route::get('console/member/catalogues/redeem_item/show/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'show']);
Route::get('console/member/catalogues/redeem_item/edit/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'edit']);
Route::post('console/member/catalogues/redeem_item/update/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'update']);
Route::get('console/member/catalogues/redeem_item/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\RedeemItemController::class, 'destroy']);

// Console Catalogue Point Item
Route::get('console/member/catalogues/point_items', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'index']);
Route::get('console/member/catalogues/point_item/create', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'create']);
Route::post('console/member/catalogues/point_item/store', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'store']);
Route::get('console/member/catalogues/point_item/show/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'show']);
Route::get('console/member/catalogues/point_item/edit/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'edit']);
Route::post('console/member/catalogues/point_item/update/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'update']);
Route::get('console/member/catalogues/point_item/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\Catalogues\PointItemController::class, 'destroy']);

// Console Members
Route::get('console/member/mile_stones', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'index']);
Route::get('console/member/mile_stone/create', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'create']);
Route::post('console/member/mile_stone/store', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'store']);
Route::get('console/member/mile_stone/show/{uniqid}', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'show']);
Route::get('console/member/mile_stone/edit/{uniqid}', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'edit']);
Route::post('console/member/mile_stone/update/{uniqid}', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'update']);
Route::get('console/member/mile_stone/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\MileStoneController::class, 'destroy']);

// Console Members
Route::get('console/member/members', [App\Http\Controllers\Admin\Member\MemberController::class, 'index']);
Route::get('console/member/member/create', [App\Http\Controllers\Admin\Member\MemberController::class, 'create']);
Route::post('console/member/member/store', [App\Http\Controllers\Admin\Member\MemberController::class, 'store']);
Route::get('console/member/member/show/{uniqid}', [App\Http\Controllers\Admin\Member\MemberController::class, 'show']);
Route::get('console/member/member/edit/{uniqid}', [App\Http\Controllers\Admin\Member\MemberController::class, 'edit']);
Route::post('console/member/member/update/{uniqid}', [App\Http\Controllers\Admin\Member\MemberController::class, 'update']);
Route::get('console/member/member/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\MemberController::class, 'destroy']);
Route::get('console/member/member/email_check', [App\Http\Controllers\Admin\Member\MemberController::class, 'check_email']);

// Console Member Level
Route::get('console/member/levels', [App\Http\Controllers\Admin\Member\LevelController::class, 'index']);
Route::get('console/member/level/create', [App\Http\Controllers\Admin\Member\LevelController::class, 'create']);
Route::post('console/member/level/store', [App\Http\Controllers\Admin\Member\LevelController::class, 'store']);
Route::get('console/member/level/show/{uniqid}', [App\Http\Controllers\Admin\Member\LevelController::class, 'show']);
Route::get('console/member/level/edit/{uniqid}', [App\Http\Controllers\Admin\Member\LevelController::class, 'edit']);
Route::post('console/member/level/update/{uniqid}', [App\Http\Controllers\Admin\Member\LevelController::class, 'update']);
Route::get('console/member/level/destroy/{uniqid}', [App\Http\Controllers\Admin\Member\LevelController::class, 'destroy']);

// HR
Route::get('hr/register', [App\Http\Controllers\Hr\RegisterController::class, 'index']);
Route::get('hr/register/email_check', [App\Http\Controllers\Hr\RegisterController::class, 'check_email']);
Route::post('hr/register/submit', [App\Http\Controllers\Hr\RegisterController::class, 'submit']);

Route::get('hr/login/index', [App\Http\Controllers\Hr\LoginController::class, 'index']);
Route::post('hr/login', [App\Http\Controllers\Hr\LoginController::class, 'Login']);
Route::get('hr/logout', [App\Http\Controllers\Hr\LoginController::class, 'logout']);

Route::get('hr/dashboard/index', [App\Http\Controllers\Hr\DashboardController::class, 'index']);

Route::get('hr/appointments/appointments', [App\Http\Controllers\Hr\AppointmentController::class, 'index']);
Route::get('hr/appointments/appointment/create', [App\Http\Controllers\Hr\AppointmentController::class, 'create']);
Route::post('hr/appointments/appointment/store', [App\Http\Controllers\Hr\AppointmentController::class, 'store']);
Route::get('hr/appointments/appointment/edit/{id}', [App\Http\Controllers\Hr\AppointmentController::class, 'edit']);
Route::post('hr/appointments/appointment/update/{id}', [App\Http\Controllers\Hr\AppointmentController::class, 'update']);
Route::get('hr/appointments/appointment/destroy/{id}', [App\Http\Controllers\Hr\AppointmentController::class, 'destroy']);
Route::get('hr/appointments/appointment/package_stores', [App\Http\Controllers\Hr\AppointmentController::class, 'package_stores']);

Route::get('hr/appointments/customers', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'index']);
Route::get('hr/appointments/customer/create', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'create']);
Route::post('hr/appointments/customer/store', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'store']);
Route::get('hr/appointments/customer/edit/{id}', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'edit']);
Route::post('hr/appointments/customer/update/{id}', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'update']);
Route::get('hr/appointments/customer/destroy/{id}', [App\Http\Controllers\Hr\AppointmentCustomerController::class, 'destroy']);

Route::get('hr/role/permissions', [App\Http\Controllers\Hr\RoleController::class, 'permissions']);

Route::get('hr/users', [App\Http\Controllers\Hr\UserController::class, 'index']);
Route::get('hr/user/create', [App\Http\Controllers\Hr\UserController::class, 'create']);
Route::post('hr/user/store', [App\Http\Controllers\Hr\UserController::class, 'store']);
Route::get('hr/user/edit/{id}', [App\Http\Controllers\Hr\UserController::class, 'edit']);
Route::post('hr/user/update/{id}', [App\Http\Controllers\Hr\UserController::class, 'update']);
Route::get('hr/user/destroy/{id}', [App\Http\Controllers\Hr\UserController::class, 'destroy']);
Route::get('hr/user/email_check', [App\Http\Controllers\Hr\UserController::class, 'check_email']);
Route::get('hr/user/login_email_check', [App\Http\Controllers\Hr\UserController::class, 'check_login_email']);

// Hr Branch Order 
Route::get('hr/branches/orders',               [App\Http\Controllers\Hr\Branch\OrderController::class, 'index']);
Route::get('hr/branches/commissions',               [App\Http\Controllers\Hr\Branch\CommissionController::class, 'index']);

// Hr Sales Order
Route::get('hr/sales/orders',               [App\Http\Controllers\Hr\Sale\OrderController::class, 'index']);
Route::get('hr/sales/order/create',         [App\Http\Controllers\Hr\Sale\OrderController::class, 'create']);
Route::post('hr/sales/order/store',         [App\Http\Controllers\Hr\Sale\OrderController::class, 'store']);
Route::get('hr/sales/order/edit/{id}',      [App\Http\Controllers\Hr\Sale\OrderController::class, 'edit']);
Route::post('hr/sales/order/update/{id}',   [App\Http\Controllers\Hr\Sale\OrderController::class, 'update']);
Route::get('hr/sales/order/destroy/{id}',   [App\Http\Controllers\Hr\Sale\OrderController::class, 'destroy']);
Route::get('hr/sales/order/customer_email_check', [App\Http\Controllers\Hr\Sale\OrderController::class, 'check_email']);
Route::get('hr/sales/order/customer_telephone_check', [App\Http\Controllers\Hr\Sale\OrderController::class, 'check_telephone']);

// Hr Sale Transaction
Route::get('hr/sales/transactions',               [App\Http\Controllers\Hr\Sale\TransactionController::class, 'index']);

// Hr Sales Branch Order
Route::get('hr/sales/branch_orders',               [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'index']);
Route::get('hr/sales/branch_order/create',         [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'create']);
Route::post('hr/sales/branch_order/store',         [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'store']);
Route::get('hr/sales/branch_order/edit/{id}',      [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'edit']);
Route::post('hr/sales/branch_order/update/{id}',   [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'update']);
Route::get('hr/sales/branch_order/destroy/{id}',   [App\Http\Controllers\Hr\Sale\BranchOrderController::class, 'destroy']);

// Hr Sales Referal
Route::get('hr/sales/referals',               [App\Http\Controllers\Hr\Sale\ReferalController::class, 'index']);

// Hr Setting
Route::get('hr/settings/profile',           [App\Http\Controllers\Hr\Setting\ProfileController::class, 'index']);
Route::post('hr/settings/profile/update/',  [App\Http\Controllers\Hr\Setting\ProfileController::class, 'update']);

// Branch
Route::get('branch/system/index', [App\Http\Controllers\Branch\SettingController::class, 'index']);
Route::get('branch/check_session', [App\Http\Controllers\Branch\CheckSessionController::class, 'index']);
Route::get('branch/dashboard', [App\Http\Controllers\Branch\DashboardController::class, 'index']);
Route::post('branch/login', [App\Http\Controllers\Branch\LoginController::class, 'Login']);
Route::get('branch/logout', [App\Http\Controllers\Branch\LoginController::class, 'logout']);

// Branch Appointment
Route::get('branch/appointments', [App\Http\Controllers\Branch\AppointmentController::class, 'index']);
Route::get('branch/appointment/edit/{id}', [App\Http\Controllers\Branch\AppointmentController::class, 'edit']);
Route::post('branch/appointment/update/{id}', [App\Http\Controllers\Branch\AppointmentController::class, 'update']);

// Branch Category
Route::get('branch/catelog/categories', [App\Http\Controllers\Branch\Catelog\CategoryController::class, 'index']);
Route::post('branch/catelog/category/store', [App\Http\Controllers\Branch\Catelog\CategoryController::class, 'store']);
Route::get('branch/catelog/category/edit/{id}', [App\Http\Controllers\Branch\Catelog\CategoryController::class, 'edit']);
Route::post('branch/catelog/category/update/{id}', [App\Http\Controllers\Branch\Catelog\CategoryController::class, 'update']);
Route::get('branch/catelog/category/destroy/{id}', [App\Http\Controllers\Branch\Catelog\CategoryController::class, 'destroy']);

// Branch Item
Route::get('branch/catelog/items', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'index']);
Route::get('branch/catelog/item/create', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'create']);
Route::post('branch/catelog/item/store', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'store']);
Route::get('branch/catelog/item/edit/{id}', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'edit']);
Route::post('branch/catelog/item/update/{id}', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'update']);
Route::get('branch/catelog/item/destroy/{id}', [App\Http\Controllers\Branch\Catelog\ItemController::class, 'destroy']);

// Branch Order
Route::get('branch/sales/orders', [App\Http\Controllers\Branch\OrderController::class, 'index']);
Route::get('branch/sales/order/create', [App\Http\Controllers\Branch\OrderController::class, 'create']);
Route::get('branch/sales/order/appointment_order_create/{id}', [App\Http\Controllers\Branch\OrderController::class, 'create']);
Route::post('branch/sales/order/store', [App\Http\Controllers\Branch\OrderController::class, 'store']);
Route::get('branch/sales/order/edit/{id}', [App\Http\Controllers\Branch\OrderController::class, 'edit']);
Route::post('branch/sales/order/update/{id}', [App\Http\Controllers\Branch\OrderController::class, 'update']);
Route::get('branch/sales/order/destroy/{id}', [App\Http\Controllers\Branch\OrderController::class, 'destroy']);

// Branch Member Catalogues Item
Route::get('branch/member/catalogues/redeem_items', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'index']);
Route::get('branch/member/catalogues/redeem_item/create', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'create']);
Route::post('branch/member/catalogues/redeem_item/store', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'store']);
Route::get('branch/member/catalogues/redeem_item/edit/{uniqid}', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'edit']);
Route::post('branch/member/catalogues/redeem_item/update/{uniqid}', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'update']);
Route::get('branch/member/catalogues/redeem_item/destroy/{uniqid}', [App\Http\Controllers\Branch\Member\Catalogues\RedeemItemController::class, 'destroy']);

// Branch Member Marketing Coupon
Route::get('branch/member/marketings/coupons', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'index']);
Route::get('branch/member/marketings/coupon/create', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'create']);
Route::post('branch/member/marketings/coupon/store', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'store']);
Route::get('branch/member/marketings/coupon/edit/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'edit']);
Route::post('branch/member/marketings/coupon/update/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'update']);
Route::get('branch/member/marketings/coupon/destroy/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\CouponController::class, 'destroy']);

// Branch Member Marketing Promotion
Route::get('branch/member/marketings/promotions', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'index']);
Route::get('branch/member/marketings/promotion/create', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'create']);
Route::post('branch/member/marketings/promotion/store', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'store']);
Route::get('branch/member/marketings/promotion/edit/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'edit']);
Route::post('branch/member/marketings/promotion/update/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'update']);
Route::get('branch/member/marketings/promotion/destroy/{uniqid}', [App\Http\Controllers\Branch\Member\Marketings\PromotionController::class, 'destroy']);

// Branch Member Order 
Route::get('branch/member/sales/orders', [App\Http\Controllers\Branch\Member\Sales\OrderController::class, 'index']);
Route::get('branch/member/sales/order/search/member', [App\Http\Controllers\Branch\Member\Sales\OrderController::class, 'search_member']);
Route::get('branch/member/sales/order/create', [App\Http\Controllers\Branch\Member\Sales\OrderController::class, 'create']);
Route::post('branch/member/sales/order/store', [App\Http\Controllers\Branch\Member\Sales\OrderController::class, 'store']);

// Branch Setting 
Route::get('branch/settings/profile/', [App\Http\Controllers\Branch\Setting\ProfileController::class, 'index']);
Route::post('branch/settings/profile/update', [App\Http\Controllers\Branch\Setting\ProfileController::class, 'update']);

// Customer
Route::post('signup', [App\Http\Controllers\Page\SignupController::class, 'signup']);
Route::post('forgot_password', [App\Http\Controllers\Page\LoginController::class, 'forgot_password']);
Route::post('page_login_index', [App\Http\Controllers\Page\LoginController::class, 'index']);
Route::post('page_login_submit', [App\Http\Controllers\Page\LoginController::class, 'submit']);
Route::get('page_logout', [App\Http\Controllers\Page\LoginController::class, 'logout']);
Route::get('customer/home', [App\Http\Controllers\Page\HomeController::class, 'index']);

Route::get('customer_appointments', [App\Http\Controllers\Page\AppointmentController::class, 'index']);
Route::get('customer_orders', [App\Http\Controllers\Page\OrderController::class, 'index']);
Route::get('customer_order_show/{id}', [App\Http\Controllers\Page\OrderController::class, 'show']);
Route::get('customer/setting', [App\Http\Controllers\Page\SettingController::class, 'customer_info']);
Route::post('customer/setting/update', [App\Http\Controllers\Page\SettingController::class, 'customer_update']);

Route::get('logout', [App\Http\Controllers\Admin\LoginController::class, 'logout']);
Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index']);
Route::post('login', [App\Http\Controllers\Admin\LoginController::class, 'login']);
Route::get('logout', [App\Http\Controllers\Admin\LoginController::class, 'logout']);

Route::get('appointment_index', [App\Http\Controllers\Admin\AppointmentController::class, 'index']);
Route::post('appointment_store', [App\Http\Controllers\Admin\AppointmentController::class, 'store']);
Route::get('appointment_edit/{id}', [App\Http\Controllers\Admin\AppointmentController::class, 'edit']);
Route::post('appointment_update/{id}', [App\Http\Controllers\Admin\AppointmentController::class, 'update']);
Route::get('appointment_destroy/{id}', [App\Http\Controllers\Admin\AppointmentController::class, 'destroy']);

Route::get('appointment_section_index', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'index']);
Route::get('appointment_section_create', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'create']);
Route::post('appointment_section_store', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'store']);
Route::get('appointment_section_show/{id}', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'show']);
Route::get('appointment_section_edit/{id}', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'edit']);
Route::post('appointment_section_update/{id}', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'update']);
Route::get('appointment_section_destroy/{id}', [App\Http\Controllers\Admin\AppointmentSectionController::class, 'destroy']);

Route::get('appointment_status_index', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'index']);
Route::get('appointment_status_create', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'create']);
Route::post('appointment_status_store', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'store']);
Route::get('appointment_status_show/{id}', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'show']);
Route::get('appointment_status_edit/{id}', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'edit']);
Route::post('appointment_status_update/{id}', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'update']);
Route::get('appointment_status_destroy/{id}', [App\Http\Controllers\Admin\AppointmentStatusController::class, 'destroy']);


Route::get('customer_index', [App\Http\Controllers\Admin\CustomerController::class, 'index']);
Route::get('customer_create', [App\Http\Controllers\Admin\CustomerController::class, 'create']);
Route::get('customer_email_check', [App\Http\Controllers\Admin\CustomerController::class, 'check_email']);
Route::get('customer_telephone_check', [App\Http\Controllers\Admin\CustomerController::class, 'check_telephone']);
Route::post('customer_store', [App\Http\Controllers\Admin\CustomerController::class, 'store']);
Route::post('customer_hr_user', [App\Http\Controllers\Admin\CustomerController::class, 'hr_user']);
Route::post('customer_email/{id}', [App\Http\Controllers\Admin\CustomerController::class, 'email_send']);
Route::get('customer_edit/{id}', [App\Http\Controllers\Admin\CustomerController::class, 'edit']);
Route::post('customer_update/{id}', [App\Http\Controllers\Admin\CustomerController::class, 'update']);
Route::get('customer_destroy/{id}', [App\Http\Controllers\Admin\CustomerController::class, 'destroy']);

Route::post('customer_package_update/{id}', [App\Http\Controllers\Admin\CustomerPackageController::class, 'update']);

Route::get('console/catalog/categories', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'index']);
Route::get('console/catalog/category/create', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'create']);
Route::post('console/catalog/category/store', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'store']);
Route::get('console/catalog/category/show/{id}', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'show']);
Route::get('console/catalog/category/edit/{id}', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'edit']);
Route::post('console/catalog/category/update/{id}', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'update']);
Route::get('console/catalog/category/destroy/{id}', [App\Http\Controllers\Admin\Catalog\CategoryController::class, 'destroy']);

Route::get('console/catalog/items', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'index']);
Route::get('console/catalog/item/create', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'create']);
Route::post('console/catalog/item/store', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'store']);
Route::get('console/catalog/item/show/{id}', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'show']);
Route::get('console/catalog/item/edit/{id}', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'edit']);
Route::post('console/catalog/item/update/{id}', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'update']);
Route::get('console/catalog/item/destroy/{id}', [App\Http\Controllers\Admin\Catalog\ItemController::class, 'destroy']);

Route::get('console/catalog/packages', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'index']);
Route::get('console/catalog/package/create', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'create']);
Route::post('console/catalog/package/store', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'store']);
Route::get('console/catalog/package/show/{id}', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'show']);
Route::get('console/catalog/package/edit/{id}', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'edit']);
Route::post('console/catalog/package/update/{id}', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'update']);
Route::get('console/catalog/package/destroy/{id}', [App\Http\Controllers\Admin\Catalog\PackageController::class, 'destroy']);

Route::get('project_index', [App\Http\Controllers\Admin\ProjectController::class, 'index']);
Route::get('project_create', [App\Http\Controllers\Admin\ProjectController::class, 'create']);
Route::post('project_store', [App\Http\Controllers\Admin\ProjectController::class, 'store']);
Route::get('project_edit/{id}', [App\Http\Controllers\Admin\ProjectController::class, 'edit']);
Route::post('project_update/{id}', [App\Http\Controllers\Admin\ProjectController::class, 'update']);
Route::get('project_destroy/{id}', [App\Http\Controllers\Admin\ProjectController::class, 'destroy']);

Route::get('project_status_index', [App\Http\Controllers\Admin\ProjectStatusController::class, 'index']);
Route::get('project_status_create', [App\Http\Controllers\Admin\ProjectStatusController::class, 'create']);
Route::post('project_status_store', [App\Http\Controllers\Admin\ProjectStatusController::class, 'store']);
Route::get('project_status_show/{id}', [App\Http\Controllers\Admin\ProjectStatusController::class, 'show']);
Route::get('project_status_edit/{id}', [App\Http\Controllers\Admin\ProjectStatusController::class, 'edit']);
Route::post('project_status_update/{id}', [App\Http\Controllers\Admin\ProjectStatusController::class, 'update']);
Route::get('project_status_destroy/{id}', [App\Http\Controllers\Admin\ProjectStatusController::class, 'destroy']);

Route::get('task_index', [App\Http\Controllers\Admin\TaskController::class, 'index']);
Route::get('task_create', [App\Http\Controllers\Admin\TaskController::class, 'create']);
Route::post('task_store', [App\Http\Controllers\Admin\TaskController::class, 'store']);
Route::get('task_show/{id}', [App\Http\Controllers\Admin\TaskController::class, 'show']);
Route::get('task_edit/{id}', [App\Http\Controllers\Admin\TaskController::class, 'edit']);
Route::post('task_update/{id}', [App\Http\Controllers\Admin\TaskController::class, 'update']);
Route::get('task_destroy/{id}', [App\Http\Controllers\Admin\TaskController::class, 'destroy']);

Route::get('task_status_index', [App\Http\Controllers\Admin\TaskStatusController::class, 'index']);
Route::get('task_status_create', [App\Http\Controllers\Admin\TaskStatusController::class, 'create']);
Route::post('task_status_store', [App\Http\Controllers\Admin\TaskStatusController::class, 'store']);
Route::get('task_status_show/{id}', [App\Http\Controllers\Admin\TaskStatusController::class, 'show']);
Route::get('task_status_edit/{id}', [App\Http\Controllers\Admin\TaskStatusController::class, 'edit']);
Route::post('task_status_update/{id}', [App\Http\Controllers\Admin\TaskStatusController::class, 'update']);
Route::get('task_status_destroy/{id}', [App\Http\Controllers\Admin\TaskStatusController::class, 'destroy']);

Route::get('console/sales/orders', [App\Http\Controllers\Admin\OrderController::class, 'index']);
Route::get('console/sales/order/create', [App\Http\Controllers\Admin\OrderController::class, 'create']);
Route::post('console/sales/order/store', [App\Http\Controllers\Admin\OrderController::class, 'store']);
Route::get('console/sales/order/show/{id}', [App\Http\Controllers\Admin\OrderController::class, 'show']);
Route::get('console/sales/order/edit/{id}', [App\Http\Controllers\Admin\OrderController::class, 'edit']);
Route::post('console/sales/order/update/{id}', [App\Http\Controllers\Admin\OrderController::class, 'update']);
Route::get('console/sales/order/destroy/{id}', [App\Http\Controllers\Admin\OrderController::class, 'destroy']);
// Route::get('order_invoice/{id}', [App\Http\Controllers\Admin\OrderController::class, 'download']);
// Route::get('order_pdf_download/{id}', [App\Http\Controllers\Admin\OrderController::class, 'pdf_download']);

Route::get('order_mail/{id}',[App\Http\Controllers\Admin\MailController::class, 'order_email']);

Route::get('order_transaction_index', [App\Http\Controllers\Admin\OrderTransactionController::class, 'index']);
Route::post('order_transaction_store', [App\Http\Controllers\Admin\OrderTransactionController::class, 'store']);
// Route::post('order_transaction_create', [App\Http\Controllers\Admin\OrderTransactionController::class, 'create']);
Route::get('order_transaction_show/{id}', [App\Http\Controllers\Admin\OrderTransactionController::class, 'show']);
Route::get('order_transaction_edit/{id}', [App\Http\Controllers\Admin\OrderTransactionController::class, 'edit']);
Route::post('order_transaction_update/{id}', [App\Http\Controllers\Admin\OrderTransactionController::class, 'update']);
Route::get('order_transaction_destroy/{id}', [App\Http\Controllers\Admin\OrderTransactionController::class, 'destroy']);


Route::get('order_status_index', [App\Http\Controllers\Admin\OrderStatusController::class, 'index']);
Route::post('order_status_store', [App\Http\Controllers\Admin\OrderStatusController::class, 'store']);
Route::get('order_status_create', [App\Http\Controllers\Admin\OrderStatusController::class, 'create']);
Route::get('order_status_show/{id}', [App\Http\Controllers\Admin\OrderStatusController::class, 'show']);
Route::get('order_status_edit/{id}', [App\Http\Controllers\Admin\OrderStatusController::class, 'edit']);
Route::post('order_status_update/{id}', [App\Http\Controllers\Admin\OrderStatusController::class, 'update']);
Route::get('order_status_destroy/{id}', [App\Http\Controllers\Admin\OrderStatusController::class, 'destroy']);


// Sales Payment Methods
Route::get('console/sales/payment_methods', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'index']);
Route::post('console/sales/payment_method/store', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'store']);
Route::get('console/sales/payment_method/create', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'create']);
Route::get('console/sales/payment_method/show/{id}', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'show']);
Route::get('console/sales/payment_method/edit/{id}', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'edit']);
Route::post('console/sales/payment_method/update/{id}', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'update']);
Route::get('console/sales/payment_method/destroy/{id}', [App\Http\Controllers\Admin\Sales\PaymentMethodController::class, 'destroy']);

Route::get('setting_system_index', [App\Http\Controllers\Admin\SettingController::class, 'systemIndex']);
Route::post('setting_system_update', [App\Http\Controllers\Admin\SettingController::class, 'systemUpdate']);

Route::get('setting_invoice_index', [App\Http\Controllers\Admin\SettingController::class, 'invoiceIndex']);
Route::post('setting_invoice_update', [App\Http\Controllers\Admin\SettingController::class, 'invoiceUpdate']);

Route::get('setting_mail_index', [App\Http\Controllers\Admin\SettingController::class, 'mailIndex']);
Route::post('setting_mail_update', [App\Http\Controllers\Admin\SettingController::class, 'mailUpdate']);

Route::get('setting_stripe_index', [App\Http\Controllers\Admin\SettingController::class, 'stripeIndex']);
Route::post('setting_stripe_update', [App\Http\Controllers\Admin\SettingController::class, 'stripeUpdate']);

Route::get('console/systme/setting/paypal/index', [App\Http\Controllers\Admin\SettingController::class, 'paypalIndex']);
Route::post('console/systme/setting/paypal/update', [App\Http\Controllers\Admin\SettingController::class, 'paypalUpdate']);

Route::get('setting_twillio_index', [App\Http\Controllers\Admin\SettingController::class, 'twillioIndex']);
Route::post('setting_twillio_update', [App\Http\Controllers\Admin\SettingController::class, 'twillioUpdate']);

Route::get('get_all_permissions', [App\Http\Controllers\Admin\PermissionController::class, 'get_all_permissions']);
Route::post('add_role_permissions', [App\Http\Controllers\Admin\PermissionController::class, 'add_role_permissions']);

Route::get('users_index', [App\Http\Controllers\Admin\UserController::class, 'index']);
Route::get('users_email_check', [App\Http\Controllers\Admin\UserController::class, 'check_email']);
Route::get('users_company_email_check', [App\Http\Controllers\Admin\UserController::class, 'check_company_email']);
Route::post('user_store', [App\Http\Controllers\Admin\UserController::class, 'store']);
Route::get('user_create', [App\Http\Controllers\Admin\UserController::class, 'create']);
Route::get('user_show/{id}', [App\Http\Controllers\Admin\UserController::class, 'show']);
Route::get('user_edit/{id}', [App\Http\Controllers\Admin\UserController::class, 'edit']);
Route::post('user_update/{id}', [App\Http\Controllers\Admin\UserController::class, 'update']);
Route::get('user_destroy/{id}', [App\Http\Controllers\Admin\UserController::class, 'destroy']);

Route::get('role_permissions', [App\Http\Controllers\Admin\RoleController::class, 'role_permissions']);
Route::get('roles_index', [App\Http\Controllers\Admin\RoleController::class, 'index']);
Route::get('role_create', [App\Http\Controllers\Admin\RoleController::class, 'create']);
Route::post('role_store', [App\Http\Controllers\Admin\RoleController::class, 'store']);
Route::get('role_show/{id}', [App\Http\Controllers\Admin\RoleController::class, 'show']);
Route::get('role_edit/{id}', [App\Http\Controllers\Admin\RoleController::class, 'edit']);
Route::post('role_update/{id}', [App\Http\Controllers\Admin\RoleController::class, 'update']);
Route::get('role_destroy/{id}', [App\Http\Controllers\Admin\RoleController::class, 'destroy']);

Route::get('languages_index', [App\Http\Controllers\Admin\LanguageController::class, 'index']);
Route::get('language_create', [App\Http\Controllers\Admin\LanguageController::class, 'create']);
Route::post('language_store', [App\Http\Controllers\Admin\LanguageController::class, 'store']);
Route::get('language_show/{id}', [App\Http\Controllers\Admin\LanguageController::class, 'show']);
Route::get('language_edit/{id}', [App\Http\Controllers\Admin\LanguageController::class, 'edit']);
Route::post('language_update/{id}', [App\Http\Controllers\Admin\LanguageController::class, 'update']);
Route::get('language_destroy/{id}', [App\Http\Controllers\Admin\LanguageController::class, 'destroy']);

Route::get('company_index', [App\Http\Controllers\Admin\CompanyController::class, 'index']);
Route::get('company_create', [App\Http\Controllers\Admin\CompanyController::class, 'create']);
Route::post('company_store', [App\Http\Controllers\Admin\CompanyController::class, 'store']);
Route::get('company_show/{id}', [App\Http\Controllers\Admin\CompanyController::class, 'show']);
Route::get('company_edit/{id}', [App\Http\Controllers\Admin\CompanyController::class, 'edit']);
Route::post('company_update/{id}', [App\Http\Controllers\Admin\CompanyController::class, 'update']);
Route::get('company_destroy/{id}', [App\Http\Controllers\Admin\CompanyController::class, 'destroy']);

Route::get('store_index', [App\Http\Controllers\Admin\StoreController::class, 'index']);
Route::get('store_create', [App\Http\Controllers\Admin\StoreController::class, 'create']);
Route::post('store_store', [App\Http\Controllers\Admin\StoreController::class, 'store']);
Route::get('store_show/{id}', [App\Http\Controllers\Admin\StoreController::class, 'show']);
Route::get('store_edit/{id}', [App\Http\Controllers\Admin\StoreController::class, 'edit']);
Route::post('store_update/{id}', [App\Http\Controllers\Admin\StoreController::class, 'update']);
Route::get('store_destroy/{id}', [App\Http\Controllers\Admin\StoreController::class, 'destroy']);
Route::get('store_email_check', [App\Http\Controllers\Admin\StoreController::class, 'check_email']);
Route::get('store_login_email_check', [App\Http\Controllers\Admin\StoreController::class, 'check_login_email']);


// Console Hr Roles
Route::get('console/hr/roles', [App\Http\Controllers\Admin\Hr\RoleController::class, 'index']);
Route::get('console/hr/role/create', [App\Http\Controllers\Admin\Hr\RoleController::class, 'create']);
Route::post('console/hr/role/store', [App\Http\Controllers\Admin\Hr\RoleController::class, 'store']);
Route::get('console/hr/role/show/{id}', [App\Http\Controllers\Admin\Hr\RoleController::class, 'show']);
Route::get('console/hr/role/edit/{id}', [App\Http\Controllers\Admin\Hr\RoleController::class, 'edit']);
Route::post('console/hr/role/update/{id}', [App\Http\Controllers\Admin\Hr\RoleController::class, 'update']);
Route::get('console/hr/role/destroy/{id}', [App\Http\Controllers\Admin\Hr\RoleController::class, 'destroy']);


// Console Hr Users
Route::get('console/hr/users', [App\Http\Controllers\Admin\Hr\UserController::class, 'index']);
Route::get('console/hr/user/create', [App\Http\Controllers\Admin\Hr\UserController::class, 'create']);
Route::post('console/hr/user/store', [App\Http\Controllers\Admin\Hr\UserController::class, 'store']);
Route::get('console/hr/user/show/{id}', [App\Http\Controllers\Admin\Hr\UserController::class, 'show']);
Route::get('console/hr/user/edit/{id}', [App\Http\Controllers\Admin\Hr\UserController::class, 'edit']);
Route::post('console/hr/user/update/{id}', [App\Http\Controllers\Admin\Hr\UserController::class, 'update']);
Route::get('console/hr/user/destroy/{id}', [App\Http\Controllers\Admin\Hr\UserController::class, 'destroy']);
Route::get('console/hr/user/email_check', [App\Http\Controllers\Admin\Hr\UserController::class, 'check_email']);
Route::get('console/hr/user/login_email_check', [App\Http\Controllers\Admin\Hr\UserController::class, 'check_login_email']);

// Console Hr Sale Orders
Route::get('console/hr/sales/orders', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'index']);
// Route::get('console/hr/sales/order/create', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'create']);
Route::post('console/hr/sales/order/store', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'store']);
// Route::get('console/hr/sales/order/show/{id}', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'show']);
// Route::get('console/hr/sales/order/edit/{id}', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'edit']);
// Route::post('console/hr/sales/order/update/{id}', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'update']);
Route::get('console/hr/sales/order/destroy/{id}', [App\Http\Controllers\Admin\Hr\Sales\OrderController::class, 'destroy']);

// Console Hr Sale Branch Orders
Route::get('console/hr/sales/branch_orders', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'index']);
// Route::get('console/hr/sales/branch_order/create', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'create']);
Route::post('console/hr/sales/branch_order/store', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'store']);
// Route::get('console/hr/sales/branch_order/show/{id}', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'show']);
// Route::get('console/hr/sales/branch_order/edit/{id}', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'edit']);
// Route::post('console/hr/sales/branch_order/update/{id}', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'update']);
Route::get('console/hr/sales/branch_order/destroy/{id}', [App\Http\Controllers\Admin\Hr\Sales\BranchOrderController::class, 'destroy']);

// Route::get('console/hr/appointments', [App\Http\Controllers\Admin\Hr\ApppintmentController::class, 'index']);
Route::get('console/hr/appointments/appointments', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'index']);
Route::get('console/hr/appointments/appointment/create', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'create']);
Route::post('console/hr/appointments/appointment/store', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'store']);
Route::get('console/hr/appointments/appointment/edit/{id}', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'edit']);
Route::post('console/hr/appointments/appointment/update/{id}', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'update']);
Route::get('console/hr/appointments/appointment/destroy/{id}', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'destroy']);
Route::get('console/hr/appointments/appointment/package_stores', [App\Http\Controllers\Admin\Hr\AppointmentController::class, 'package_stores']);

//
Route::get('console/hr/commissions/referals', [App\Http\Controllers\Admin\Hr\Commissions\ReferalController::class, 'index']);
Route::post('console/hr/commissions/referal/store', [App\Http\Controllers\Admin\Hr\Commissions\ReferalController::class, 'store']);
Route::get('console/hr/commissions/referal/destroy/{id}', [App\Http\Controllers\Admin\Hr\Commissions\ReferalController::class, 'destroy']);

// 
Route::get('console/hr/commissions/users', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'index']);
Route::get('console/hr/commissions/user/create', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'create']);
Route::post('console/hr/commissions/user/store', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'store']);
Route::get('console/hr/commissions/user/edit/{id}', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'edit']);
Route::post('console/hr/commissions/user/update/{id}', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'update']);
Route::get('console/hr/commissions/user/destroy/{id}', [App\Http\Controllers\Admin\Hr\Commissions\UserController::class, 'destroy']);

Route::get('console/hr/commissions/superiors', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'index']);
Route::get('console/hr/commissions/superior/create', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'create']);
Route::post('console/hr/commissions/superior/store', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'store']);
Route::get('console/hr/commissions/superior/edit/{id}', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'edit']);
Route::post('console/hr/commissions/superior/update/{id}', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'update']);
Route::get('console/hr/commissions/superior/destroy/{id}', [App\Http\Controllers\Admin\Hr\Commissions\SuperiorController::class, 'destroy']);

Route::get('console/hr/reports/users', [App\Http\Controllers\Admin\Hr\ReportController::class, 'users']);
Route::get('console/hr/reports/superiors', [App\Http\Controllers\Admin\Hr\ReportController::class, 'superiors']);
Route::get('console/hr/reports/teams', [App\Http\Controllers\Admin\Hr\ReportController::class, 'teams']);
Route::get('console/hr/reports/rewards', [App\Http\Controllers\Admin\Hr\ReportController::class, 'rewards']);



Route::get('console/hr/others/commission/index', [App\Http\Controllers\Admin\Hr\OtherCommissionController::class, 'index']);
Route::post('console/hr/others/commission/update', [App\Http\Controllers\Admin\Hr\OtherCommissionController::class, 'update']);

Route::get('console/branch/categories', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'index']);
Route::get('console/branch/category/create', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'create']);
Route::post('console/branch/category/store', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'store']);
Route::get('console/branch/category/show/{id}', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'show']);
Route::get('console/branch/category/edit/{id}', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'edit']);
Route::post('console/branch/category/update/{id}', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'update']);
Route::get('console/branch/category/destroy/{id}', [App\Http\Controllers\Admin\Branch\CategoryController::class, 'destroy']);

Route::get('console/branch/items', [App\Http\Controllers\Admin\Branch\ItemController::class, 'index']);
Route::get('console/branch/item/create', [App\Http\Controllers\Admin\Branch\ItemController::class, 'create']);
Route::post('console/branch/item/store', [App\Http\Controllers\Admin\Branch\ItemController::class, 'store']);
Route::get('console/branch/item/show/{id}', [App\Http\Controllers\Admin\Branch\ItemController::class, 'show']);
Route::get('console/branch/item/edit/{id}', [App\Http\Controllers\Admin\Branch\ItemController::class, 'edit']);
Route::post('console/branch/item/update/{id}', [App\Http\Controllers\Admin\Branch\ItemController::class, 'update']);
Route::get('console/branch/item/destroy/{id}', [App\Http\Controllers\Admin\BranchItem\Controller::class, 'destroy']);

Route::get('console/branch/customers', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'index']);
Route::get('console/branch/customer/create', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'create']);
Route::post('console/branch/customer/store', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'store']);
Route::get('console/branch/customer/show/{id}', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'show']);
Route::get('console/branch/customer/edit/{id}', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'edit']);
Route::post('console/branch/customer/update/{id}', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'update']);
Route::get('console/branch/customer/destroy/{id}', [App\Http\Controllers\Admin\Branch\CustomerController::class, 'destroy']);

Route::get('console/branch/orders', [App\Http\Controllers\Admin\Branch\OrderController::class, 'index']);
Route::get('console/branch/order/create', [App\Http\Controllers\Admin\Branch\OrderController::class, 'create']);
Route::post('console/branch/order/store', [App\Http\Controllers\Admin\Branch\OrderController::class, 'store']);
Route::get('console/branch/order/show/{id}', [App\Http\Controllers\Admin\Branch\OrderController::class, 'show']);
Route::get('console/branch/order/edit/{id}', [App\Http\Controllers\Admin\Branch\OrderController::class, 'edit']);
Route::post('console/branch/order/update/{id}', [App\Http\Controllers\Admin\Branch\OrderController::class, 'update']);
Route::get('console/branch/order/destroy/{id}', [App\Http\Controllers\Admin\Branch\OrderController::class, 'destroy']);
Route::get('console/branch/order/customer_check', [App\Http\Controllers\Admin\Branch\OrderController::class, 'branch_customer']);
Route::get('console/branch/order/customer_packages', [App\Http\Controllers\Admin\Branch\OrderController::class, 'customer_packages']);
Route::get('console/branch/order/branch_items', [App\Http\Controllers\Admin\Branch\OrderController::class, 'branch_items']);

Route::get('console/branch/transactions', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'index']);
Route::get('console/branch/transaction/create', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'create']);
Route::post('console/branch/transaction/store', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'store']);
Route::get('console/branch/transaction/show/{id}', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'show']);
Route::get('console/branch/transaction/edit/{id}', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'edit']);
Route::post('console/branch/transaction/update/{id}', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'update']);
Route::get('console/branch/transaction/destroy/{id}', [App\Http\Controllers\Admin\Branch\TransactionController::class, 'destroy']);

// Member
Route::get('member/register', [App\Http\Controllers\Member\RegisterController::class, 'index']);
Route::get('member/register/email_check', [App\Http\Controllers\Member\RegisterController::class, 'check_email']);
Route::post('member/register/submit', [App\Http\Controllers\Member\RegisterController::class, 'submit']);

Route::get('member/login/index', [App\Http\Controllers\Member\LoginController::class, 'index']);
Route::post('member/login', [App\Http\Controllers\Member\LoginController::class, 'Login']);
Route::get('member/logout', [App\Http\Controllers\Member\LoginController::class, 'logout']);

Route::get('member/dashboard', [App\Http\Controllers\Member\DashboardController::class, 'index']);

Route::get('member/point_items', [App\Http\Controllers\Member\PointItemController::class, 'index']);
Route::get('member/point_item/show/{id}', [App\Http\Controllers\Member\PointItemController::class, 'show']);
Route::post('member/point_item/payment', [App\Http\Controllers\Member\PointItemController::class, 'paypal_payment']);
Route::get('member/point_item/paypal/callback/{params}', [App\Http\Controllers\Member\PointItemController::class, 'paypal_callback']);

Route::get('member/redeem/stores', [App\Http\Controllers\Member\RedeemItemController::class, 'stores']);
Route::get('member/redeem_items', [App\Http\Controllers\Member\RedeemItemController::class, 'index']);
Route::get('member/redeem_item/store/{id}', [App\Http\Controllers\Member\RedeemItemController::class, 'store']);
Route::post('member/redeem_item/add_order', [App\Http\Controllers\Member\RedeemItemController::class, 'add_order']);

Route::get('member/sales/transactions', [App\Http\Controllers\Member\Sales\TransactionController::class, 'index']);

Route::get('member/sales/orders', [App\Http\Controllers\Member\Sales\OrderController::class, 'index']);
Route::get('member/sales/order/show/{uniqid}', [App\Http\Controllers\Member\Sales\OrderController::class, 'show']);

Route::get('member/personal_information/name', [App\Http\Controllers\Member\PersonalInformationController::class, 'name']);
Route::post('member/personal_information/name', [App\Http\Controllers\Member\PersonalInformationController::class, 'name']);

Route::get('member/personal_information/email', [App\Http\Controllers\Member\PersonalInformationController::class, 'email']);
Route::post('member/personal_information/email', [App\Http\Controllers\Member\PersonalInformationController::class, 'email']);

Route::get('member/personal_information/telephone', [App\Http\Controllers\Member\PersonalInformationController::class, 'telephone']);
Route::post('member/personal_information/telephone', [App\Http\Controllers\Member\PersonalInformationController::class, 'telephone']);

Route::get('member/personal_information/password', [App\Http\Controllers\Member\PersonalInformationController::class, 'password']);
Route::post('member/personal_information/password', [App\Http\Controllers\Member\PersonalInformationController::class, 'password']);

Route::get('member/personal_information/language', [App\Http\Controllers\Member\PersonalInformationController::class, 'language']);
Route::post('member/personal_information/language', [App\Http\Controllers\Member\PersonalInformationController::class, 'language']);

Route::get('member/personal_information/birthday', [App\Http\Controllers\Member\PersonalInformationController::class, 'birthday']);
Route::post('member/personal_information/birthday', [App\Http\Controllers\Member\PersonalInformationController::class, 'birthday']);

Route::get('member/membership', [App\Http\Controllers\Member\MembershipController::class, 'index']);

// Route::post('paypal/pay', [App\Http\Controllers\PaypalController::class, 'create']);
